---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：23-Route Handlers

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **C-18**：HEADメソッド自動サポートの具体的実装の根拠確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/route-modules/app-route/module.ts` - AppRouteRouteModuleメイン実装（1253行）
- E-02: `packages/next/src/server/route-modules/app-route/helpers/auto-implement-methods.ts` - 自動メソッド実装
- E-03: `packages/next/src/server/route-modules/app-route/helpers/is-static-gen-enabled.ts` - 静的生成判定
- E-04: `packages/next/src/server/web/http.ts` - HTTPメソッド定義
- E-05: `packages/next/src/server/lib/patch-fetch.ts` - fetch拡張
- E-06: `packages/next/src/server/web/spec-extension/request.ts` - NextRequest
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTTPメソッド別のハンドラ関数をresolve()で取得 | E-01 (295-301行目) | ○ |
| C-02 | isHTTPMethodによるメソッドバリデーション | E-01 (297行目), E-04 | ○ |
| C-03 | 大文字メソッド名必須、小文字は開発時警告 | E-01 (257-269行目) | ○ |
| C-04 | defaultエクスポート禁止、開発時警告 | E-01 (273-277行目) | ○ |
| C-05 | Response返却必須、それ以外はエラー | E-01 (650-666行目) | ○ |
| C-06 | POST/PUT/DELETE/PATCH/OPTIONSは非静的メソッド | E-01 (861-873行目) | ○ |
| C-07 | NextResponse.rewrite()禁止 | E-01 (835-839行目) | ○ |
| C-08 | NextResponse.next()禁止 | E-01 (841-845行目) | ○ |
| C-09 | Server Action時のリダイレクトは303 | E-01 (637-639行目) | ○ |
| C-10 | patchFetchによるfetch API拡張 | E-01 (319-322行目), E-05 | ○ |
| C-11 | dynamic設定（force-dynamic/force-static/error/auto）の適用 | E-01 (760-797行目) | ○ |
| C-12 | force-staticでリクエストをProxyでラップ | E-01 (774-780行目) | ○ |
| C-13 | proxyNextRequestでdynamicアクセスを追跡 | E-01 (1009-1095行目) | ○ |
| C-14 | OpenTelemetryトレーシング統合 | E-01 (805-823行目) | ○ |
| C-15 | Cookie統合処理（appendMutableCookies） | E-01 (682-689行目) | ○ |
| C-16 | 静的生成時のprospective render + final render | E-01 (364-585行目) | ○ |
| C-17 | output:exportでforce-dynamicはエラー | E-01 (242-253行目) | ○ |
| C-18 | GETのみ定義時にHEADメソッドも自動サポート | **根拠なし** (E-02の詳細未読) | △ |

## 4) 不足情報（Unknown / Missing）
- auto-implement-methods.tsの詳細なHEADメソッド自動実装ロジックが未確認
  - 候補：`packages/next/src/server/route-modules/app-route/helpers/auto-implement-methods.ts`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メインモジュールのロジックは詳細に確認済み
- 0: 低リスク - エラー処理とバリデーションは明確にコードで確認済み
- 0: 低リスク - 静的生成のprospective/final renderパターンも確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] resolve()メソッドのHTTPメソッドバリデーションが正確か確認
- [ ] dynamic設定のswitch文が全パターンをカバーしているか確認
- [ ] auto-implement-methods.tsのHEADメソッド自動実装を確認
